/*
 Adapted from the Adafruit graphicstest sketch, see orignal header at end
 of sketch.

 This sketch uses the GLCD font (font 1) only.

 Make sure all the display driver and pin comnenctions are correct by
 editting the User_Setup.h file in the TFT_eSPI library folder.

 #########################################################################
 ###### DON'T FORGET TO UPDATE THE User_Setup.h FILE IN THE LIBRARY ######
 #########################################################################
*/

#include "SPI.h"
#include "TFT_eSPI.h"

TFT_eSPI tft = TFT_eSPI();

const int cFONT_SIZE_X = 6;
const int cFONT_SIZE_Y = 8;
const int cFONT_SCALE = 2;
const int cNAME_LENGTH = 16;
const int cDPS_LENGTH = 10;
const int cTITLE_POS_X = 28;
const int cTITLE_POS_Y = 32;
const int cMAX_SYMBOLS = 17;
const int cMAX_MEMBERS = 15;

char names[cMAX_MEMBERS][cMAX_SYMBOLS];
char dps[cMAX_MEMBERS][cMAX_SYMBOLS];
char names_old[cMAX_MEMBERS][cMAX_SYMBOLS];
char dps_old[cMAX_MEMBERS][cMAX_SYMBOLS];
bool title_display = true;

unsigned long total = 0;

void setup() {
  Serial.begin(9600);
  while (!Serial);

  Serial.println(""); Serial.println("");
  Serial.println("TFT_eSPI library test!");

  tft.init();
  tft.fillScreen(TFT_BLACK);
  tft.setRotation(1);
  _title();

  int line;
  int column;
  for( line = 0; line < cMAX_MEMBERS; ++line ) {
    for( column = 0; column < cMAX_SYMBOLS; ++column ) {
      names[line][column] = 0;
      dps[line][column] = 0;
      names_old[line][column] = 0;
      dps_old[line][column] = 0;
    }
  }
}

void loop(void) {
  if (Serial.available() > 0){
    if( title_display ) {
      _removeTitle();
    }
    
    String input = Serial.readStringUntil(';');
    if(0 < input.length() ){
      tft.setTextSize(2);
    
      int members = 0;
      const char* pData = input.c_str();
      int mode = 0;
      int cnt = 0;
      while(1){
        char sym = *pData++;
        if( 0 == mode ) {
          if( sym == ':' ) {
            names[members][cnt] = 0;
            dps[members][0] = ':'; 
            mode = 1;
            cnt = 1;
          } else {
            names[members][cnt++] = sym;
          }
        } else {
          if( sym == '/' ) {
            dps[members++][cnt] = 0;
            break;
          } else if( sym == ',' ) {
            dps[members++][cnt] = 0;
            if( members == cMAX_MEMBERS ) {
              break;
            } else {
              mode = 0;
              cnt = 0;
            }
          } else {
            dps[members][cnt++] = sym;
          }
        }
      }
      for(;members < cMAX_MEMBERS; ++members) {
        names[members][0] = 0;
        dps[members][0] = 0;
      }
      
      int line;
      for( line = 0; line < cMAX_MEMBERS; ++line ) {
        int column;
        bool change = false;
        int color = TFT_WHITE;
    
        for( column = 0; column < cMAX_SYMBOLS; ++column ) {
          if( names[line][column] != names_old[line][column] ) {
            change = true;
            break;   
          }
        }
    
        if( names[line][0] == 'Y' && names[line][1] == 'O' && names[line][2] == 'U' && names[line][3] == 0 ) {
          color = TFT_RED; 
        }
        tft.setTextColor(color);
    
        // name update
        if( change ) {
          tft.fillRect( 0, line * cFONT_SIZE_Y * cFONT_SCALE, cFONT_SIZE_X * cFONT_SCALE * cNAME_LENGTH, cFONT_SIZE_Y * cFONT_SCALE, TFT_BLACK );
          tft.setCursor( 0, line * cFONT_SIZE_Y * cFONT_SCALE );
          tft.print( names[line] );
        }
    
        change = false;
        for( column = 0; column < cMAX_SYMBOLS; ++column ) {
          if( dps[line][column] != dps_old[line][column] ) {
            change = true;
            break;   
          }
        }
        if( change ) {
          tft.fillRect( cFONT_SIZE_X * cFONT_SCALE * cNAME_LENGTH, line * cFONT_SIZE_Y * cFONT_SCALE, cFONT_SIZE_X * cFONT_SCALE * cDPS_LENGTH, cFONT_SIZE_Y * cFONT_SCALE, TFT_BLACK );
          tft.setCursor( cFONT_SIZE_X * cFONT_SCALE * cNAME_LENGTH, line * cFONT_SIZE_Y * cFONT_SCALE );
          tft.print( dps[line] );
        }
    
        for( column = 0; column < cMAX_SYMBOLS; ++column ) {
          names_old[line][column] = names[line][column]; 
          dps_old[line][column] = dps[line][column]; 
        }
      }
    }
  }
}

void _title()
{
  tft.fillScreen(TFT_BLACK);
  tft.setTextColor(TFT_RED);
  tft.setTextSize(cFONT_SCALE);
  tft.setCursor(cTITLE_POS_X, cTITLE_POS_Y);
  tft.println("[ ACT encdps monitor ]");
}

void _removeTitle()
{
  tft.fillRect( 0, cTITLE_POS_Y, 320, cTITLE_POS_Y + cFONT_SIZE_Y * cFONT_SCALE, TFT_BLACK );
  title_display = false;
}
