// IMPORTANT: Adafruit_TFTLCD LIBRARY MUST BE SPECIFICALLY
// CONFIGURED FOR EITHER THE TFT SHIELD OR THE BREAKOUT BOARD.
// SEE RELEVANT COMMENTS IN Adafruit_TFTLCD.h FOR SETUP.
//Technical support:goodtft@163.com

#include <Adafruit_GFX.h>    // Core graphics library
#include <Adafruit_TFTLCD.h> // Hardware-specific library

// The control pins for the LCD can be assigned to any digital or
// analog pins...but we'll use the analog pins as this allows us to
// double up the pins with the touch screen (see the TFT paint example).
#define LCD_CS A3 // Chip Select goes to Analog 3
#define LCD_CD A2 // Command/Data goes to Analog 2
#define LCD_WR A1 // LCD Write goes to Analog 1
#define LCD_RD A0 // LCD Read goes to Analog 0

#define LCD_RESET A4 // Can alternately just connect to Arduino's reset pin

// When using the BREAKOUT BOARD only, use these 8 data lines to the LCD:
// For the Arduino Uno, Duemilanove, Diecimila, etc.:
//   D0 connects to digital pin 8  (Notice these are
//   D1 connects to digital pin 9   NOT in order!)
//   D2 connects to digital pin 2
//   D3 connects to digital pin 3
//   D4 connects to digital pin 4
//   D5 connects to digital pin 5
//   D6 connects to digital pin 6
//   D7 connects to digital pin 7
// For the Arduino Mega, use digital pins 22 through 29
// (on the 2-row header at the end of the board).

// Assign human-readable names to some common 16-bit color values:
#define	BLACK   0x0000
#define	BLUE    0x001F
#define	RED     0xF800
#define	GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

Adafruit_TFTLCD tft(LCD_CS, LCD_CD, LCD_WR, LCD_RD, LCD_RESET);
// If using the shield, all control and data lines are fixed, and
// a simpler declaration can optionally be used:
// Adafruit_TFTLCD tft;

const int cFONT_SIZE_X = 6;
const int cFONT_SIZE_Y = 8;
const int cFONT_SCALE = 2;
const int cNAME_LENGTH = 16;
const int cDPS_LENGTH = 10;
const int cTITLE_POS_X = 28;
const int cTITLE_POS_Y = 32;
const int cMAX_SYMBOLS = 17;
const int cMAX_MEMBERS = 15;

char names[cMAX_MEMBERS][cMAX_SYMBOLS];
char dps[cMAX_MEMBERS][cMAX_SYMBOLS];
char names_old[cMAX_MEMBERS][cMAX_SYMBOLS];
char dps_old[cMAX_MEMBERS][cMAX_SYMBOLS];
bool title_display = true;

void setup(void) {
  Serial.begin(9600);
  Serial.println(F("TFT LCD test"));

#ifdef USE_ADAFRUIT_SHIELD_PINOUT
  Serial.println(F("Using Adafruit 2.4\" TFT Arduino Shield Pinout"));
#else
  Serial.println(F("Using Adafruit 2.4\" TFT Breakout Board Pinout"));
#endif

  Serial.print("TFT size is "); Serial.print(tft.width()); Serial.print("x"); Serial.println(tft.height());

  tft.reset();

  uint16_t identifier = tft.readID();
   if(identifier == 0x9325) {
    Serial.println(F("Found ILI9325 LCD driver"));
  } else if(identifier == 0x9328) {
    Serial.println(F("Found ILI9328 LCD driver"));
  } else if(identifier == 0x4535) {
    Serial.println(F("Found LGDP4535 LCD driver"));
  }else if(identifier == 0x7575) {
    Serial.println(F("Found HX8347G LCD driver"));
  } else if(identifier == 0x9341) {
    Serial.println(F("Found ILI9341 LCD driver"));
  } else if(identifier == 0x8357) {
    Serial.println(F("Found HX8357D LCD driver"));
  } else if(identifier==0x0101)
  {     
      identifier=0x9341;
       Serial.println(F("Found 0x9341 LCD driver"));
  }else {
    Serial.print(F("Unknown LCD driver chip: "));
    Serial.println(identifier, HEX);
    Serial.println(F("If using the Adafruit 2.8\" TFT Arduino shield, the line:"));
    Serial.println(F("  #define USE_ADAFRUIT_SHIELD_PINOUT"));
    Serial.println(F("should appear in the library header (Adafruit_TFT.h)."));
    Serial.println(F("If using the breakout board, it should NOT be #defined!"));
    Serial.println(F("Also if using the breakout, double-check that all wiring"));
    Serial.println(F("matches the tutorial."));
    identifier=0x9341;
  }

  tft.begin(identifier);
  tft.setRotation(1);
  _title();

  int line;
  int column;
  for( line = 0; line < cMAX_MEMBERS; ++line ) {
    for( column = 0; column < cMAX_SYMBOLS; ++column ) {
      names[line][column] = 0;
      dps[line][column] = 0;
      names_old[line][column] = 0;
      dps_old[line][column] = 0;
    }
  }
}

void loop(void) {

  if (Serial.available() > 0){
    if( title_display ) {
      _removeTitle();
    }
    
    String input = Serial.readStringUntil(';');
    if(0 < input.length() ){
      tft.setTextSize(2);
    
      int members = 0;
      const char* pData = input.c_str();
      int mode = 0;
      int cnt = 0;
      while(1){
        char sym = *pData++;
        if( 0 == mode ) {
          if( sym == ':' ) {
            names[members][cnt] = 0;
            dps[members][0] = ':'; 
            mode = 1;
            cnt = 1;
          } else {
            names[members][cnt++] = sym;
          }
        } else {
          if( sym == '/' ) {
            dps[members++][cnt] = 0;
            break;
          } else if( sym == ',' ) {
            dps[members++][cnt] = 0;
            if( members == cMAX_MEMBERS ) {
              break;
            } else {
              mode = 0;
              cnt = 0;
            }
          } else {
            dps[members][cnt++] = sym;
          }
        }
      }
      for(;members < cMAX_MEMBERS; ++members) {
        names[members][0] = 0;
        dps[members][0] = 0;
      }
      
      int line;
      for( line = 0; line < cMAX_MEMBERS; ++line ) {
        int column;
        bool change = false;
        int color = WHITE;
    
        for( column = 0; column < cMAX_SYMBOLS; ++column ) {
          if( names[line][column] != names_old[line][column] ) {
            change = true;
            break;   
          }
        }
    
        if( names[line][0] == 'Y' && names[line][1] == 'O' && names[line][2] == 'U' && names[line][3] == 0 ) {
          color = RED; 
        }
        tft.setTextColor(color);
    
        // name update
        if( change ) {
          tft.fillRect( 0, line * cFONT_SIZE_Y * cFONT_SCALE, cFONT_SIZE_X * cFONT_SCALE * cNAME_LENGTH, cFONT_SIZE_Y * cFONT_SCALE, BLACK );
          tft.setCursor( 0, line * cFONT_SIZE_Y * cFONT_SCALE );
          tft.print( names[line] );
        }
    
        change = false;
        for( column = 0; column < cMAX_SYMBOLS; ++column ) {
          if( dps[line][column] != dps_old[line][column] ) {
            change = true;
            break;   
          }
        }
        if( change ) {
          tft.fillRect( cFONT_SIZE_X * cFONT_SCALE * cNAME_LENGTH, line * cFONT_SIZE_Y * cFONT_SCALE, cFONT_SIZE_X * cFONT_SCALE * cDPS_LENGTH, cFONT_SIZE_Y * cFONT_SCALE, BLACK );
          tft.setCursor( cFONT_SIZE_X * cFONT_SCALE * cNAME_LENGTH, line * cFONT_SIZE_Y * cFONT_SCALE );
          tft.print( dps[line] );
        }
    
        for( column = 0; column < cMAX_SYMBOLS; ++column ) {
          names_old[line][column] = names[line][column]; 
          dps_old[line][column] = dps[line][column]; 
        }
      }
    }
  }
}

void _title()
{
  tft.fillScreen(BLACK);
  tft.setTextColor(RED);
  tft.setTextSize(cFONT_SCALE);
  tft.setCursor(cTITLE_POS_X, cTITLE_POS_Y);
  tft.println("[ ACT encdps monitor ]");
}

void _removeTitle()
{
  tft.fillRect( 0, cTITLE_POS_Y, 320, cTITLE_POS_Y + cFONT_SIZE_Y * cFONT_SCALE, BLACK );
  title_display = false;
}
